/* eslint-disable max-len,no-param-reassign */
define([
    'underscore',
    'App',
    'Vent',
    'modules/form/form-view-mixin',
    'modules/page/content/single-column-layout-view',
    'modules/form/leave-confirmation/leave-confirmation-popup-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-service-distance-layout-view',
    'text!modules/new-appointment-wizard/wizard-layout.html',
],
function(
    _,
    App,
    vent,
    Mixin,
    SingleColumnLayoutView,
    LeaveConfirmationPopup,
    WizardStepModel,
    CCServiceDistanceLayoutView,
    template
) {
    'use strict';

    return SingleColumnLayoutView.extend(Mixin.form({
        className: 'community-care primary-content',
        template: _.template(template),
        regions: {currentWizardPageLayout: '.current-wizard-page-layout'},
        events: {'click #back-btn': 'toExit'},

        initialize: function(options) {
            if (_.isUndefined(this.model)) {
                this.model = new WizardStepModel();
            }
            this.loadEventSettings();
            this.wizardPageManager = [];
            App.wizardActive = true;
        },
        onRender: function() {
            this.initializeFormValidation({errorLabelContainer: '.error-list'});
            this.hideErrorSection();
            this.showCurrentWizardPageLayout(CCServiceDistanceLayoutView, 1);
        },
        hideErrorSection: function() {
            if (!this.isDestroyed()) {
                this.$el.find('.error-section').addClass('hidden');
            }
        },
        showErrorSection: function() {
            if (!this.isDestroyed()) {
                this.$el.find('.error-section').removeClass('hidden');
                this.$el.find('#error-list-heading').focus();
            }
        },
        isValid: function() {
            return this.$el.find('form').valid();
        },
        resetFormValidation: function() {
            this.hideErrorSection();
            this.validator.resetForm();
        },
        // Events handle
        loadEventSettings: function() {
            // bind wizard page events
            this.listenTo(vent, 'show:previousWizardPage', this.showPreviousWizardPageLayout);
            this.listenTo(vent, 'show:nextWizardPage', this.showCurrentWizardPageLayout);
            this.listenTo(vent, 'update:wizardSteps', this.updateWizardPageSteps);
            this.listenTo(vent, 'wizard:exit', this.handleExitWizard);
        },
        // This navigates to the next wizard page
        showCurrentWizardPageLayout: function(WizardPage, wizardPageSteps) {
            var wizardPageObj = {
                wizardPage: WizardPage,
                wizardPageSteps: this.generateStepsArray(wizardPageSteps, false),
            };
            this.wizardPageManager.push(wizardPageObj);
            this.model.set('steps', wizardPageObj.wizardPageSteps);
            this.showChildView('currentWizardPageLayout', new WizardPage({
                model: this.model,
                validator: this.validator,
                isValid: this.isValid.bind(this),
            }));
        },
        // This navigates to the previous Wizard page
        showPreviousWizardPageLayout: function(wizardPageSteps) {
            var wizardPageObj;
            var WizardPage;

            this.wizardPageManager.pop();
            wizardPageObj = this.wizardPageManager[this.wizardPageManager.length - 1];
            this.model.set('steps', wizardPageObj.wizardPageSteps);
            WizardPage = wizardPageObj.wizardPage;
            this.showChildView('currentWizardPageLayout', new WizardPage({
                model: this.model,
                validator: this.validator,
                isValid: this.isValid.bind(this),
            }));
        },
        // The purpose of this method is for pages that change steps based on user input
        updateWizardPageSteps: function(wizardPageSteps, showWizardPageLayout) {
            var wizardPageObj = this.wizardPageManager[this.wizardPageManager.length - 1];
            var WizardPage;

            wizardPageObj.wizardPageSteps = this.generateStepsArray(wizardPageSteps, true);
            this.model.set('steps', wizardPageObj.wizardPageSteps);
            if (showWizardPageLayout) {
                WizardPage = wizardPageObj.wizardPage;
                this.showChildView('currentWizardPageLayout', new WizardPage({
                    model: this.model,
                    validator: this.validator,
                    isValid: this.isValid.bind(this),
                }));
            }
        },
        generateStepsArray: function(steps, isCurrentPage) {
            var currentStep = 0;
            var currentWizardPageSteps;
            var nextWizardPageSteps;

            if (this.wizardPageManager.length > 0) {
                currentWizardPageSteps = this.wizardPageManager[this.wizardPageManager.length - 1].wizardPageSteps;
                currentStep = (isCurrentPage) ? currentWizardPageSteps[0] : currentWizardPageSteps[currentWizardPageSteps.length - 1];

                if (isCurrentPage) {
                    steps--;
                }
            }
            nextWizardPageSteps = (isCurrentPage) ? [currentStep] : [];
            while (steps > 0) {
                nextWizardPageSteps.push(++currentStep);
                steps--;
            }
            return nextWizardPageSteps;
        },
        routeToExit: function() {
            window.location.hash = '#';
            App.wizardActive = false;
        },
        toExit: function(e) {
            var leaveConfirmationPopup;

            if (this.model.hasChanged() || this.model.has('service')) {
                leaveConfirmationPopup = new LeaveConfirmationPopup({
                    elAfterClose: $(e.currentTarget),
                    continue: this.routeToExit,
                });
                leaveConfirmationPopup.openPopup();
            } else {
                this.routeToExit();
            }
        },
        handleExitWizard: function(e, callback) {
            // when: field is dirty and need to show exit modal
            // then: show exit modal - on the exit modal this needs to be able to invoke callback() when the user hits continue
            var leaveConfirmationPopup;

            if (this.model.has('service')) {
                leaveConfirmationPopup = new LeaveConfirmationPopup({
                    elAfterClose: $(e.currentTarget),
                    continue: callback,
                });
                leaveConfirmationPopup.openPopup();
            } else {
                callback();
            }
        },
    }));
});
